/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.speedController;

import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.content.kinetics.RotationPropagator;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.motor.KineticScrollValueBehaviour;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.kinetics.speedController.SpeedControllerBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class SpeedControllerBlockEntity
extends KineticBlockEntity {
    public static final int DEFAULT_SPEED = 16;
    public ScrollValueBehaviour targetSpeed;
    public AbstractComputerBehaviour computerBehaviour;
    boolean hasBracket = false;

    public SpeedControllerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.updateBracket();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        Integer max = (Integer)AllConfigs.server().kinetics.maxRotationSpeed.get();
        this.targetSpeed = new KineticScrollValueBehaviour((class_2561)CreateLang.translateDirect("kinetics.speed_controller.rotation_speed", new Object[0]), this, new ControllerValueBoxTransform());
        this.targetSpeed.between(-max.intValue(), max);
        this.targetSpeed.value = 16;
        this.targetSpeed.withCallback(i -> this.updateTargetRotation());
        behaviours.add(this.targetSpeed);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
        this.registerAwardables(behaviours, AllAdvancements.SPEED_CONTROLLER);
    }

    private void updateTargetRotation() {
        if (this.hasNetwork()) {
            this.getOrCreateNetwork().remove(this);
        }
        RotationPropagator.handleRemoved(this.field_11863, this.field_11867, this);
        this.removeSource();
        this.attachKinetics();
        if (this.isCogwheelPresent() && this.getSpeed() != 0.0f) {
            this.award(AllAdvancements.SPEED_CONTROLLER);
        }
    }

    public static float getConveyedSpeed(KineticBlockEntity cogWheel, KineticBlockEntity speedControllerIn, boolean targetingController) {
        float compareSpeed;
        if (!(speedControllerIn instanceof SpeedControllerBlockEntity)) {
            return 0.0f;
        }
        float speed = speedControllerIn.getTheoreticalSpeed();
        float wheelSpeed = cogWheel.getTheoreticalSpeed();
        float desiredOutputSpeed = SpeedControllerBlockEntity.getDesiredOutputSpeed(cogWheel, speedControllerIn, targetingController);
        float f = compareSpeed = targetingController ? speed : wheelSpeed;
        if (desiredOutputSpeed >= 0.0f && compareSpeed >= 0.0f) {
            return Math.max(desiredOutputSpeed, compareSpeed);
        }
        if (desiredOutputSpeed < 0.0f && compareSpeed < 0.0f) {
            return Math.min(desiredOutputSpeed, compareSpeed);
        }
        return desiredOutputSpeed;
    }

    public static float getDesiredOutputSpeed(KineticBlockEntity cogWheel, KineticBlockEntity speedControllerIn, boolean targetingController) {
        SpeedControllerBlockEntity speedController = (SpeedControllerBlockEntity)speedControllerIn;
        float targetSpeed = speedController.targetSpeed.getValue();
        float speed = speedControllerIn.getTheoreticalSpeed();
        float wheelSpeed = cogWheel.getTheoreticalSpeed();
        if (targetSpeed == 0.0f) {
            return 0.0f;
        }
        if (targetingController && wheelSpeed == 0.0f) {
            return 0.0f;
        }
        if (!speedController.hasSource()) {
            if (targetingController) {
                return targetSpeed;
            }
            return 0.0f;
        }
        boolean wheelPowersController = speedController.source.equals((Object)cogWheel.method_11016());
        if (wheelPowersController) {
            if (targetingController) {
                return targetSpeed;
            }
            return wheelSpeed;
        }
        if (targetingController) {
            return speed;
        }
        return targetSpeed;
    }

    public void updateBracket() {
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.hasBracket = this.isCogwheelPresent();
        }
    }

    private boolean isCogwheelPresent() {
        class_2680 stateAbove = this.field_11863.method_8320(this.field_11867.method_10084());
        return ICogWheel.isDedicatedCogWheel(stateAbove.method_26204()) && ICogWheel.isLargeCog(stateAbove) && ((class_2350.class_2351)stateAbove.method_11654((class_2769)CogWheelBlock.AXIS)).method_10179();
    }

    private class ControllerValueBoxTransform
    extends ValueBoxTransform.Sided {
        private ControllerValueBoxTransform() {
        }

        @Override
        protected class_243 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)11.0, (double)15.5);
        }

        @Override
        protected boolean isSideActive(class_2680 state, class_2350 direction) {
            if (direction.method_10166().method_10178()) {
                return false;
            }
            return state.method_11654(SpeedControllerBlock.HORIZONTAL_AXIS) != direction.method_10166();
        }

        @Override
        public float getScale() {
            return 0.5f;
        }
    }
}

